<?php
/*shortcode*/
/*h1*/
add_shortcode('h1', 'st_hybrid_h1_shortcode');
function st_hybrid_h1_shortcode($atts, $content)
{
    extract(shortcode_atts( array('type' => ''), $atts));
    return '  <h1>'.$content.'</h1>';
}
add_action('init', 'h1_btn');
function h1_btn() {
    if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') ) {
        return;
    }

}
/*h1*/
/*h2*/
add_shortcode('h2', 'st_hybrid_h2_shortcode');
function st_hybrid_h2_shortcode($atts, $content)
{
    extract(shortcode_atts( array('type' => ''), $atts));
    return '  <h2>'.$content.'</h2>';
}
add_action('init', 'h2_btn');
function h2_btn() {
    if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') ) {
        return;
    }
}
/*h2*/
/*h3*/
add_shortcode('h3', 'st_hybrid_h3_shortcode');
function st_hybrid_h3_shortcode($atts, $content)
{
    extract(shortcode_atts( array('type' => ''), $atts));
    return '  <h3>'.$content.'</h3>';
}
add_action('init', 'h3_btn');
function h3_btn() {
    if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') ) {
        return;
    }
}
/*h3*/
/*h4*/
add_shortcode('h4', 'st_hybrid_h4_shortcode');
function st_hybrid_h4_shortcode($atts, $content)
{
    extract(shortcode_atts( array('type' => ''), $atts));
    return '  <h4>'.$content.'</h4>';
}
add_action('init', 'h4_btn');
function h4_btn() {
    if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') ) {
        return;
    }
}
/*h4*/
/*h5*/
add_shortcode('h5', 'st_hybrid_h5_shortcode');
function st_hybrid_h5_shortcode($atts, $content)
{
    extract(shortcode_atts( array('type' => ''), $atts));
    return '  <h5>'.$content.'</h5>';
}
add_action('init', 'h5_btn');
function h5_btn() {
    if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') ) {
        return;
    }
}
/*h5*/
/*h6*/
add_shortcode('h6', 'st_hybrid_h6_shortcode');
function st_hybrid_h6_shortcode($atts, $content)
{
    extract(shortcode_atts( array('type' => ''), $atts));
    return '  <h6>'.$content.'</h6>';
}
add_action('init', 'h6_btn');
function h6_btn() {
    if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') ) {
        return;
    }
}
/*h6*/
/*Youtube*/
function st_hybrid_youtube_shortcode($atts, $content=null){

    extract(shortcode_atts( array('id' => ''), $atts));
    extract(shortcode_atts( array('width' => ''), $atts));
    extract(shortcode_atts( array('height' => ''), $atts));

    $return = $content;
    if($content)
        $return .= "<br /><br />";

    $return .= '<iframe width="'.$atts['width'].'" height="'.$atts['height'].'" src="http://www.youtube.com/embed/' .$atts['id'] . '" frameborder="0" allowfullscreen></iframe>';
	
    return $return;

}
add_shortcode('youtube', 'st_hybrid_youtube_shortcode');
/*Youtube*/
/*Vimeo*/
function st_hybrid_Vimeo_shortcode($atts, $content=null){

    extract(shortcode_atts( array('id' => ''), $atts));
    extract(shortcode_atts( array('width' => ''), $atts));
    extract(shortcode_atts( array('height' => ''), $atts));

    $return = $content;
    if($content)
        $return .= "<br /><br />";

        $return .= '<iframe src="http://player.vimeo.com/video/'. $atts['id'] .'?title=0&amp;byline=0&amp;portrait=0" width="'.$atts['width'].'" height="'.$atts['height'].'" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>';

    return $return;

}
add_shortcode('Vimeo', 'st_hybrid_Vimeo_shortcode');
/*Vimeo*/
/*Tab*/
function st_hybrid_tab_shortcode($atts, $content){
    extract(shortcode_atts( array('title' => ''), $atts));
    $return_statement = '<div class="tab-all" data-title="'.$atts['title'].'">'.$content.'</div>';	
    return $return_statement;
}
add_shortcode('tab', 'st_hybrid_tab_shortcode');
/*Tab*/

/*Tab Group*/
function st_hybrid_tabgroup_shortcode($atts, $content){
    $content = do_shortcode($content);
    $return_statement ='<div class="row-fluid">
						<div class="span12">
							<div id="col-container1">
								<div class="tabs-container">
									<ul id="myTab" class="nav nav-tabs"></ul>
									<div id="myTabContent" class="tab-content"></div>
									<div class="tabAllHolder">'.$content.'</div>
                        </div></div></div></div>';
    return $return_statement;
}
add_shortcode('tabgroup', 'st_hybrid_tabgroup_shortcode');
/*Tab Group*/

/*Accordion Item*/
function st_hybrid_accordion_item_shortcode($atts, $content){
    extract(shortcode_atts( array('title' => ''), $atts));
    $return_statement = '<div class="accHeader" data-title="'.$atts['title'].'">'.$content.'</div>';
    return $return_statement;
}

add_shortcode('accordion_item', 'st_hybrid_accordion_item_shortcode');
/*Accordion Item*/
/*Accordion*/
function st_hybrid_accordion_shortcode($atts, $content){
    $content = do_shortcode($content);
    $return_statement = '<div class="row-fluid">
							<div class="span12">
								<div id="col-container2">
									<div class="accordion shortcode" id="accordion2" style="clear:both;">
										 <div class="accordion-group" id="myAcc"></div>
										 <div class="accAllHolder">'. $content.'</div></div></div></div></div>';
    return $return_statement;
}
add_shortcode('accordion', 'st_hybrid_accordion_shortcode');
/*Accordion*/

/*alertInfo*/
function st_hybrid_alertInfo_shortcode($atts, $content){
    $content = do_shortcode($content);
    //$return_statement =' <div class="alert alert-info">'.$content.' <i>X</i></div>';
	 extract(shortcode_atts( array('title' => ''), $atts));
	$return_statement = '<div class="alert alert-info"><button type="button" class="close" data-dismiss="alert">&times;</button>'.
							'<h4>'.$atts['title'].'</h4>'.
							'<p class="post-title">'.$content.'</p></div>';
    return $return_statement;
}
add_shortcode('alertInfo', 'st_hybrid_alertInfo_shortcode');
/*alertInfo*/
/*alertSuccess*/
function st_hybrid_alertSuccess_shortcode($atts, $content){
    $content = do_shortcode($content);
   // $return_statement =' <div class="alert alert-success">'.$content.' <i>X</i></div>';
	 extract(shortcode_atts( array('title' => ''), $atts));
	$return_statement = '<div class="alert alert-success"><button type="button" class="close" data-dismiss="alert">&times;</button>'.
							'<h4>'.$atts['title'].'</h4>'.
							'<p class="post-title">'.$content.'</p></div>';
    return $return_statement;
}
add_shortcode('alertSuccess', 'st_hybrid_alertSuccess_shortcode');
/*alertSuccess*/
/*alertError*/
function st_hybrid_alertError_shortcode($atts, $content){
    $content = do_shortcode($content);
   // $return_statement =' <div class="alert alert-error">'.$content.' <i>X</i></div>';
	 extract(shortcode_atts( array('title' => ''), $atts));
	$return_statement = '<div class="alert alert-error"><button type="button" class="close" data-dismiss="alert">&times;</button>'.
							'<h4>'.$atts['title'].'</h4>'.
							'<p class="post-title">'.$content.'</p></div>';
    return $return_statement;
}
add_shortcode('alertError', 'st_hybrid_alertError_shortcode');
/*alertError*/
/*alertWarning*/
function st_hybrid_alertWarning_shortcode($atts, $content){
    $content = do_shortcode($content);
    //$return_statement =' <div class="alert alert-warning">'.$content.' <i>X</i></div>';
	 extract(shortcode_atts( array('title' => ''), $atts));
	$return_statement = '<div class="alert alert-warning"><button type="button" class="close" data-dismiss="alert">&times;</button>'.
							'<h4>'.$atts['title'].'</h4>'.
							'<p class="post-title">'.$content.'</p></div>';
    return $return_statement;
}
add_shortcode('alertWarning', 'st_hybrid_alertWarning_shortcode');
/*alertWarning*/


/*fontAwesome*/
function st_hybrid_fontAwesome_shortcode($atts, $content){
    $content = do_shortcode($content);
    extract(shortcode_atts( array('name' => ''), $atts));
	extract(shortcode_atts( array('size' => ''), $atts));    

    $size = $atts['size'];
	$name = $atts['name'];    
   
    $return_statement = '<i class="'.$name.' '.$size.'"></i>';
    return $return_statement;
}
add_shortcode('fontAwesome', 'st_hybrid_fontAwesome_shortcode');

/*fontAwesome*/

/*shortcode*/

/*Generics*/

function register_button_5( $buttons ) {
    return $buttons;
}
add_filter('mce_buttons_5', 'register_button_5');

function register_button_4( $buttons ) {
    array_push( $buttons, "h1_btn" );
    array_push( $buttons, "h2_btn" );
    array_push( $buttons, "h3_btn" );
    array_push( $buttons, "h4_btn" );
    array_push( $buttons, "h5_btn" );
    array_push( $buttons, "h6_btn" );   
    array_push( $buttons, "youtube" );
    array_push( $buttons, "Vimeo" );
	array_push( $buttons, "tabs" );
	array_push( $buttons, "accordion" );
	array_push( $buttons, "alertInfo" );
    array_push( $buttons, "alertSuccess" );
    array_push( $buttons, "alertError" );
    array_push( $buttons, "alertWarning" );
    return $buttons;
}
add_filter('mce_buttons_4', 'register_button_4');

function register_button_3( $buttons ) {
	array_push($buttons,'fontAwesome');
    return $buttons;
}
add_filter('mce_buttons_3', 'register_button_3');

function add_plugin( $plugin_array ) {
    $plugin_array['h1_btn'] = get_template_directory_uri() . '/js/tiny_mce_buttons.js';
    $plugin_array['h2_btn'] = get_template_directory_uri() . '/js/tiny_mce_buttons.js';
    $plugin_array['h3_btn'] = get_template_directory_uri() . '/js/tiny_mce_buttons.js';
    $plugin_array['h4_btn'] = get_template_directory_uri() . '/js/tiny_mce_buttons.js';
    $plugin_array['h5_btn'] = get_template_directory_uri() . '/js/tiny_mce_buttons.js';
    $plugin_array['h6_btn'] = get_template_directory_uri() . '/js/tiny_mce_buttons.js';  
	$plugin_array['youtube'] = get_template_directory_uri() . '/js/tiny_mce_buttons.js';
    $plugin_array['Vimeo'] = get_template_directory_uri() . '/js/tiny_mce_buttons.js';
	$plugin_array['tabs'] = get_template_directory_uri() . '/js/tiny_mce_buttons.js';
    $plugin_array['accordion'] = get_template_directory_uri() . '/js/tiny_mce_buttons.js';
	$plugin_array['alertInfo'] = get_template_directory_uri() . '/js/tiny_mce_buttons.js';
    $plugin_array['alertSuccess'] = get_template_directory_uri() . '/js/tiny_mce_buttons.js';
    $plugin_array['alertError'] = get_template_directory_uri() . '/js/tiny_mce_buttons.js';
    $plugin_array['alertWarning'] = get_template_directory_uri() . '/js/tiny_mce_buttons.js';	
	$plugin_array['fontAwesome'] = get_template_directory_uri() . '/js/tiny_mce_buttons.js';
    return $plugin_array;
}

add_filter( 'mce_external_plugins', 'add_plugin' );

/*Generics*/
?>